IF OBJECT_ID('P_VALIDA_GTIN') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_VALIDA_GTIN
	END
GO

CREATE PROCEDURE P_VALIDA_GTIN(@CD_GTIN VARCHAR(14))AS
	DECLARE @SOMA AS INT = 0
	DECLARE @CD_POSICAO INT = 1
	DECLARE @CD_MULTIP INT = 3
	DECLARE @CD_DIGITO INT

	--Considera apenas GTIN-8, 12, 13 e 14
	IF (LEN(@CD_GTIN) = 8) OR (LEN(@CD_GTIN) = 12) OR (LEN(@CD_GTIN) = 13) OR (LEN(@CD_GTIN) = 14)
	BEGIN
		IF LEN(@CD_GTIN) = 13
		BEGIN
			SET @CD_MULTIP = 1
		END

		WHILE @CD_POSICAO < LEN(@CD_GTIN)
		BEGIN
			SET @SOMA = @SOMA + (CONVERT(INT, SUBSTRING(@CD_GTIN, @CD_POSICAO, 1)) * @CD_MULTIP)

			IF @CD_MULTIP = 1
			BEGIN
				SET @CD_MULTIP = 3
			END
			ELSE
			BEGIN
				SET @CD_MULTIP = 1
			END

			SET @CD_POSICAO = @CD_POSICAO + 1
		END

		SET @CD_DIGITO = (((@SOMA / 10) + 1) * 10) - (@SOMA)

		IF @CD_DIGITO = 10
		BEGIN
			SET @CD_DIGITO = 0
		END
		
		IF CONVERT(CHAR(1), @CD_DIGITO) = RIGHT(@CD_GTIN, 1)
		BEGIN
			SELECT 1  AS FL_VALIDO
		END
		ELSE
		BEGIN
			SELECT 0  AS FL_VALIDO
		END
	END
	ELSE
	BEGIN
		SELECT 0  AS FL_VALIDO
	END